C------------------------------------------------------------------------------
C
      PROGRAM ELCONBE
C 
C  PROGRAM 28 
C 
C  THIS PROGRAM SOLVES TWO-DIMENSIONAL (EL)ASTIC PROBLEMS 
C  USING (CON)STANT (B)OUNDARY (E)LEMENTS
C
      CHARACTER*10 FILEIN,FILEOUT
C
      COMMON/MATG/ G(100,100)
      COMMON/MATH/ H(100,100)
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR
      DIMENSION X(51),Y(51),XM(50),YM(50),FI(100),DFI(100)
      DIMENSION KODE(100),CX(20),CY(20),SSOL(60),DSOL(40)
C
C  SET MAXIMUN DIMENSION OF THE SYSTEM OF EQUATIONS (NX)
C  (THIS NUMBER MUST BE EQUAL OR SMALLER THAN THE DIMENSION OF G AND H)
C 
      NX=100
C
C  ASSIGN NUMBERS FOR INPUT AND OUTPUT FILES
C 
      INP=5 
      IPR=6
C
C  READ NAMES AND OPEN FILES FOR INPUT AND UOTPUT
C
      WRITE(*,' (A) ') ' NAME OF THE INPUT FILE (MAX. 10 CHART.)'
      READ(*,' (A) ') FILEIN
      OPEN(INP,FILE=FILEIN,STATUS='OLD')
      WRITE(*,' (A) ') ' NAME OF THE OUTPUT FILE (MAX.10 CHART.)'
      READ(*,' (A) ') FILEOUT
      OPEN(IPR,FILE=FILEOUT,STATUS='NEW')  
C
C  READ DATA 
C 
      CALL INPUTEC(CX,CY,X,Y,KODE,FI)
C 
C  COMPUTE H AND G MATRICES AND FORM SYSTEM (A X = F)
C 
      CALL GHMATEC(X,Y,XM,YM,G,H,FI,DFI,KODE,NX) 
C 
C  SOLVE SYSTEM OF EQUATIONS
C 
      NN=2*N
      CALL SLNPD(G,DFI,D,NN,NX)
C 
C  COMPUTE STRESS AND DISPLACEMENT AT INTERNAL POINTS
C 
      CALL INTEREC(FI,DFI,KODE,CX,CY,X,Y,SSOL,DSOL) 
C 
C  PRINT RESULTS AT BOUNDARY NODES AND INTERNAL POINTS  
C 
      CALL OUTPTEC(XM,YM,FI,DFI,CX,CY,SSOL,DSOL)
      CLOSE (INP)
      CLOSE (IPR)
      STOP 
      END 
C-----------------------------------------------------------------------
      SUBROUTINE INPUTEC(CX,CY,X,Y,KODE,FI)
C
C  PROGRAM 29 
C
      CHARACTER*80 TITLE
      DIMENSION CX(20),CY(20),X(51),Y(51),KODE(100),FI(100) 
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
C 
C  N= NUMBER OF BOUNDARY NODES (= NUMBER OF ELEMENTS)
C  L= NUMBER OF INTERNAL POINTS WHERE DISPLACEMENT AND STRESS
C     ARE CALCULATED   
C  M= NUMBER OF DIFFERENT BOUNDARIES
C  NC(I)= LAST NODE OF BOUNDARY I
C  GE= SHEAR MODULUS
C  XNU= POISSON MODULUS
C 
      WRITE(IPR,100)
  100 FORMAT(/' ',79('*')) 
C 
C  READ JOB TITLE
C 
      READ(INP,'(A)') TITLE 
      WRITE(IPR,'(A)') TITLE
C 
C  READ NUMBER OF NODES, INTERNAL POINTS AND DIFFERENT BOUNDARIES;
C  READ LAST NODES OF THESE BOUNDARIES AND MATERIAL PROPERTIES
C 
      READ(INP,*)N,L,M,(NC(K),K=1,5),GE,XNU 
      WRITE(IPR,300)N,L,GE,XNU
  300 FORMAT(//' DATA'//2X,'NUMBER OF BOUNDARY ELEMENTS =',I3/2X,
     1'NUMBER OF INTERNAL POINTS =',I3/2X,  
     2'SHEAR MODULUS =',E14.7/2X,'POISSON RATIO =',E14.7)
      IF(M)40,40,30 
   30 WRITE(IPR,999)M,(NC(K),K=1,M) 
  999 FORMAT(2X,'NUMBER OF DIFFERENT BOUNDARIES=',I3/2X,
     1'LAST NODES OF THESE BOUNDARIES =',5(2X,I3))
C 
C  READ COORDINATES OF EXTREME POINTS OF THE BOUNDARY 
C  ELEMENTS IN ARRAYS X AND Y
C 
   40 WRITE(IPR,500)
  500 FORMAT(//2X,'COORDINATES OF THE EXTREME POINTS OF'
     1' THE BOUNDARY ELEMENTS'//4X,'POINT',10X,'X',18X,'Y')
      READ(INP,*) (X(I),Y(I),I=1,N) 
      DO 10 I=1,N 
   10 WRITE(IPR,700)I,X(I),Y(I) 
  700 FORMAT(5X,I3,2(5X,E14.7)) 
C 
C  READ BOUNDARY CONDITIONS IN FI(I) VECTOR, IF KODE(I)=0 THE FI(I)
C  VALUE IS A KNOWN DISPLACEMENT; IF KODE(I)=1 THE FI(I) VALUE IS A 
C  KNOWN TRACTION.
C 
      WRITE(IPR,800)
  800 FORMAT(//2X,'BOUNDARY CONDITIONS'//15X,'PRESCRIBED VALUE',15X,
     1'PRESCRIBED VALUE'/5X,'NODE',9X,'X DIRECTION',8X,'CODE',8X,
     2'Y DIRECTION',8X,'CODE')
      DO 20 I=1,N 
      READ(INP,*) KODE(2*I-1),FI(2*I-1),KODE(2*I),FI(2*I) 
   20 WRITE(IPR,950)I,FI(2*I-1),KODE(2*I-1),FI(2*I),KODE(2*I) 
  950 FORMAT(5X,I3,8X,E14.7,8X,I1,8X,E14.7,8X,I1) 
C 
C  READ COORDINATES OF THE INTERNAL POINTS
C
      IF(L.EQ.0) GO TO 50 
      READ(INP,*) (CX(I),CY(I),I=1,L) 
   50 RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE GHMATEC(X,Y,XM,YM,G,H,FI,DFI,KODE,NX) 
C
C  PROGRAM 30 
C
C  THIS SUBROUTINE COMPUTES THE G AND H MATRICES AND
C  FORMS THE SYSTEM OF EQUATIONS A X = F
C
      DIMENSION G(NX,NX),H(NX,NX) 
      DIMENSION X(51),Y(51),XM(50),YM(50),FI(100) 
      DIMENSION KODE(100),DFI(100)
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR
C 
C  COMPUTE THE NODAL COORDINATES AND STORE IN ARRAYS XM AND YM
C 
      X(N+1)=X(1) 
      Y(N+1)=Y(1) 
      DO 10 I=1,N 
      XM(I)=(X(I)+X(I+1))/2 
   10 YM(I)=(Y(I)+Y(I+1))/2 
      IF(M-1)15,15,12 
   12 XM(NC(1))=(X(NC(1))+X(1))/2 
      YM(NC(1))=(Y(NC(1))+Y(1))/2 
      DO 13 K=2,M 
      XM(NC(K))=(X(NC(K))+X(NC(K-1)+1))/2 
   13 YM(NC(K))=(Y(NC(K))+Y(NC(K-1)+1))/2 
C 
C  COMPUTE THE COEFICIENTS OF G AND H MATRICES
C 
   15 DO 30 I=1,N 
      DO 30 J=1,N 
      IF(M-1)16,16,17 
   17 IF(J-NC(1))19,18,19 
   18 KK=1
      GO TO 23
   19 DO 22 K=2,M 
      IF(J-NC(K))22,21,22 
   21 KK=NC(K-1)+1
      GO TO 23
   22 CONTINUE
   16 KK=J+1
   23 IF(I-J)20,25,20 
   20 CALL EXTINEC(XM(I),YM(I),X(J),Y(J),X(KK),Y(KK),H((2*I-1),(2*J-1)),
     1H((2*I-1),(2*J)),H((2*I),(2*J-1)),H((2*I),(2*J)),G((2*I-1),
     2(2*J-1)),G((2*I-1),(2*J)),G((2*I),(2*J)))
      G((2*I),(2*J-1))=G((2*I-1),(2*J)) 
      GO TO 26
   25 CALL LOCINEC(X(J),Y(J),X(KK),Y(KK),G((2*I-1),(2*J-1)), 
     1G((2*I-1),(2*J)),G((2*I),(2*J)))  
      H((2*I-1),(2*J-1))=0.5
      H((2*I),(2*J))=0.5
      H((2*I-1),(2*J))=0. 
      H((2*I),(2*J-1))=0. 
      G((2*I),(2*J-1))=G((2*I-1),(2*J)) 
   26 CONTINUE
   30 CONTINUE
C 
C  REORDER THE COLUMNS OF THE SYSTEM OF EQUATIONS IN ACCORDANCE
C  WITH THE BOUNDARY CONDITIONS AND FORM SYSTEM MATRIX A WHICH 
C  IS STORED IN G
C 
      NN=2*N
      DO 50 J=1,NN
      IF(KODE(J))43,43,40 
   40 DO 42 I=1,NN
      CH=G(I,J) 
      G(I,J)=-H(I,J)
   42 H(I,J)=-CH
      GO TO 50
   43 DO 45 I=1,NN
   45 G(I,J)=G(I,J)*GE
   50 CONTINUE
C 
C  FORM THE RIGHT HAND SIDE VECTOR F WHICH IS STORED IN DFI
C 
      DO 60 I=1,NN
      DFI(I)=0. 
      DO 60 J=1,NN
      DFI(I)=DFI(I)+H(I,J)*FI(J)
   60 CONTINUE
      RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE EXTINEC(XP,YP,X1,Y1,X2,Y2,H11,H12,H21,H22,G11,G12,G22)
C
C  PROGRAM 31 
C 
C  THIS SOUBROUTINE COMPUTES THE G AND H MATRICES
C  COEFFICIENTS THAT RELATE A COLLOCATION POINT WITH A DIFFERENT 
C  ELEMENT USING GAUSS QUADRATURE
C
C  DIST= DISTANCE FROM THE COLOCATION POINT TO THE 
C        LINE TANGENT TO THE ELEMENT
C  RA= DISTANCE FROM THE COLOCATION POINT TO THE
C      GAUSS INTEGRATION POINT AT THE BOUNDARY ELEMENT
C 
      DIMENSION XCO(4),YCO(4),GI(4),OME(4)
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
      DATA GI/0.86113631,-0.86113631,0.33998104,-0.33998104/
      DATA OME/0.34785485,0.34785485,0.65214515,0.65214515/
C
      AX=(X2-X1)/2
      BX=(X2+X1)/2
      AY=(Y2-Y1)/2
      BY=(Y2+Y1)/2
      ETA1=(Y2-Y1)/(2*SQRT(AX**2+AY**2))
      ETA2=(X1-X2)/(2*SQRT(AX**2+AY**2))
C
C  COMPUTE THE DISTANCE FROM THE POINT TO THE LINE OF THE ELEMENT
C
      IF(AX)10,20,10
   10 TA=AY/AX
      DIST=ABS((TA*XP-YP+Y1-TA*X1)/SQRT(TA**2+1)) 
      GO TO 30
   20 DIST=ABS(XP-X1)
C
C  DETERMINE THE DIRECTION OF THE OUTWARD NORMAL
C 
   30 SIG=(X1-XP)*(Y2-YP)-(X2-XP)*(Y1-YP) 
      IF(SIG)31,32,32 
   31 DIST=-DIST
   32 H11=0.
      H12=0.
      H21=0.
      H22=0.
      G11=0.
      G12=0.
      G22=0.
C
C  COMPUTE G AND H COEFFICIENTS
C
      DE=4*3.141592*(1-XNU) 
      DO 40 I=1,4 
      XCO(I)=AX*GI(I)+BX
      YCO(I)=AY*GI(I)+BY
      RA=SQRT((XP-XCO(I))**2+(YP-YCO(I))**2)
      RD1=(XCO(I)-XP)/RA
      RD2=(YCO(I)-YP)/RA
      G11=G11+((3-4*XNU)*ALOG(1./RA)+RD1**2)*OME(I)*SQRT(AX**2+AY**2)/(2
     1*DE*GE) 
      G12=G12+RD1*RD2*OME(I)*SQRT(AX**2+AY**2)/(2*DE*GE)
      G22=G22+((3-4*XNU)*ALOG(1./RA)+RD2**2)*OME(I)*SQRT(AX**2+AY**2)/(2
     1*DE*GE) 
      H11=H11-DIST*((1-2*XNU)+2*RD1**2)/(RA**2*DE)*OME(I)*SQRT(AX**2+AY*
     1*2) 
      H12=H12-(DIST*2*RD1*RD2/RA+(1-2*XNU)*(ETA1*RD2-ETA2*RD1))*OME(I)*S
     1QRT(AX**2+AY**2)/(RA*DE)
      H21=H21-(DIST*2*RD1*RD2/RA+(1-2*XNU)*(ETA2*RD1-ETA1*RD2))*OME(I)*S
     1QRT(AX**2+AY**2)/(RA*DE)
   40 H22=H22-DIST*((1-2*XNU)+2*RD2**2)*OME(I)*SQRT(AX**2+AY**2)/(RA**2*
     1DE) 
      RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE LOCINEC(X1,Y1,X2,Y2,G11,G12,G22)
C
C  PROGRAM 32 
C 
C  THIS SUBROUTINE COMPUTES THE VALUES OF THE MATRIX G COEFFICIENTS
C  THAT RELATE AN ELEMENT WITH ITSELF
C 
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
C
      AX=(X2-X1)/2
      AY=(Y2-Y1)/2
      SR=SQRT(AX**2+AY**2)
      DE=4*3.141592*GE*(1-XNU)
      G11=SR*((3-4*XNU)*(1-ALOG(SR))+(X2-X1)**2/(4*SR**2))/DE 
      G22=SR*((3-4*XNU)*(1-ALOG(SR))+(Y2-Y1)**2/(4*SR**2))/DE 
      G12=(X2-X1)*(Y2-Y1)/(4*SR*DE) 
      RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE SLNPD(A,B,D,N,NX)
C 
C PROGRAM 6 
C 
C SOLUTION OF LINEAR SYSTEMS OF EQUATIONS 
C BY THE GAUSS ELIMINATION METHOD PROVIDING 
C FOR INTERCHANGING ROWS WHEN ENCOUNTERING A
C ZERO DIAGONAL COEFICIENT
C 
C A : SYSTEM MATRIX 
C B : ORIGINALLY IT CONTAINS THE INDEPENDENT
C     COEFFICIENTS. AFTER SOLUTION IT CONTAINS
C     THE VALUES OF THE SYSTEM UNKNOWNS.
C 
C N : ACTUAL NUMBER OF UNKNOWNS 
C NX: ROW AND COLUMN DIMENSION OF A 
C 
      COMMON NMUDO,LMUDO,NCMUDO(5),MMUDO,INP,IPR
      DIMENSION B(NX),A(NX,NX)
C
      TOL=1.E-6
C
      N1=N-1
      DO 100 K=1,N1 
      K1=K+1
      C=A(K,K)
      IF(ABS(C)-TOL)1,1,3
    1 DO 7 J=K1,N 
C 
C TRY TO INTERCHANGE ROWS TO GET NON ZERO DIAGONAL COEFFICIENT
C 
      IF(ABS((A(J,K)))-TOL)7,7,5 
    5 DO 6 L=K,N
      C=A(K,L)
      A(K,L)=A(J,L) 
    6 A(J,L)=C
      C=B(K)
      B(K)=B(J) 
      B(J)=C
      C=A(K,K)
      GO TO 3 
    7 CONTINUE
      GO TO 8
C 
C DIVIDE ROW BY DIAGONAL COEFFICIENT
C 
    3 C=A(K,K)
      DO 4 J=K1,N 
    4 A(K,J)=A(K,J)/C 
      B(K)=B(K)/C 
C 
C ELIMINATE UNKNOWN X(K) FROM ROW I 
C 
      DO 10 I=K1,N
      C=A(I,K)
      DO 9 J=K1,N 
    9 A(I,J)=A(I,J)-C*A(K,J)
   10 B(I)=B(I)-C*B(K)
  100 CONTINUE
C 
C COMPUTE LAST UNKNOWN
C 
      IF(ABS((A(N,N)))-0.000001)8,8,101 
  101 B(N)=B(N)/A(N,N)
C 
C APPLY BACKSUBSTITUTION PROCESS TO COMPUTE REMAINING UNKNOWNS
C 
      DO 200 L=1,N1 
      K=N-L 
      K1=K+1
      DO 200 J=K1,N 
  200 B(K)=B(K)-A(K,J)*B(J) 
C 
C COMPUTE VALUE OF DETERMINANT
C 
      D=1.
      DO 250 I=1,N
  250 D=D*A(I,I)
      GO TO 300
    8 WRITE(IPR,2) K
    2 FORMAT(' **** SINGULARITY IN ROW',I5) 
      D=0.
  300 RETURN
      END 
C------------------------------------------------------------------------
      SUBROUTINE INTEREC(FI,DFI,KODE,CX,CY,X,Y,SSOL,DSOL) 
C
C  PROGRAM 33
C
C  THIS SUBROUTINE COMPUTES THE VALUES OF THE STRESS AND DISPLACEMENT
C  COMPONENTS AT INTERNAL POINTS
C
      DIMENSION CX(20),CY(20),SSOL(60),DSOL(40) 
      DIMENSION FI(100),DFI(100),KODE(100),X(51),Y(51)
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
C 
C  REARRANGE FI AND DFI ARRAYS TO STORE ALL THE VALUES
C  OF THE DISPLACEMENT IN FI AND ALL THE VALUES OF THE TRACTIONS IN DFI
C 
      NN=2*N
      DO 20 I=1,NN
      IF(KODE(I)) 15,15,10
   10 CH=FI(I)
      FI(I)=DFI(I)
      DFI(I)=CH 
      GO TO 20
   15 DFI(I)=DFI(I)*GE
   20 CONTINUE
C 
C  COMPUTE THER VALUES OF STRESSES AND DISPLACEMENTS
C  AT INTERNAL POINTS.  
C 
      IF(L.EQ.0) GO TO 50
      DO 40 K=1,L 
      DSOL(2*K-1)=0.
      DSOL(2*K)=0.
      SSOL(3*K-2)=0.
      SSOL(3*K-1)=0.
      SSOL(3*K)=0.
      DO 30 J=1,N 
      IF(M-1)28,28,22 
   22 IF(J-NC(1))24,23,24 
   23 KK=1
      GO TO 29
   24 DO 26 LK=2,M
      IF(J-NC(LK))26,25,26
   25 KK=NC(LK-1)+1 
      GO TO 29
   26 CONTINUE
   28 KK=J+1
   29 CALL EXTINEC(CX(K),CY(K),X(J),Y(J),X(KK),Y(KK),H11,H12,H21,H22,
     1 G11,G12,G22) 
      DSOL(2*K-1)=DSOL(2*K-1)+DFI(2*J-1)*G11+DFI(2*J)*G12-FI(2*J-1)*H11-
     1FI(2*J)*H12 
      DSOL(2*K)=DSOL(2*K)+DFI(2*J-1)*G12+DFI(2*J)*G22-FI(2*J-1)*H21-FI(2
     1*J)*H22 
      CALL SIGMAEC(CX(K),CY(K),X(J),Y(J),X(KK),Y(KK),D111,D211,D112,
     1 D212,D122,D222,S111,S211,S112,S212,S122,S222) 
      SSOL(3*K-2)=SSOL(3*K-2)+DFI(2*J-1)*D111+DFI(2*J)*D211-FI(2*J-1)*S1
     111-FI(2*J)*S211 
      SSOL(3*K-1)=SSOL(3*K-1)+DFI(2*J-1)*D112+DFI(2*J)*D212-FI(2*J-1)*S1
     112-FI(2*J)*S212 
   30 SSOL(3*K)=SSOL(3*K)+DFI(2*J-1)*D122+DFI(2*J)*D222-FI(2*J-1)*S122-F
     1I(2*J)*S222 
   40 CONTINUE
   50 RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE SIGMAEC(XP,YP,X1,Y1,X2,Y2,D111,D211,D112,D212,D122,
     1 D222,S111,S211,S112,S212,S122,S222) 
C
C  PROGRAM 34 
C 
C  THIS SUBROUTINE COMPUTES THE VALUES OF THE S AND D MATRICES
C  USING GAUSS QUADRATURE IN ORDER TO COMPUTE THE STRESSES
C  AT ANY INTERNAL POINT  
C
C  RA= DISTANCE FROM THE POINT TO THE GAUSS INTEGRATION POINTS
C      ON THE BOUNDARY ELEMENTS
C  DIST=   DISTANCE FROM THE POINT TO THE LINE TANGENT 
C          TO THE ELEMENT
C  RD1,RD2=   DERIVATIVES OF RA
C  ETA1,ETA2= COMPONENTS OF THE UNIT NORMAL TO THE ELEMENT
C 
      DIMENSION XCO(4),YCO(4),GI(4),OME(4)
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
      DATA GI/0.86113631,-0.86113631,0.33998104,-0.33998104/
      DATA OME/0.34785485,0.34785485,0.65214515,0.65214515/
C
      AX=(X2-X1)/2
      BX=(X2+X1)/2
      AY=(Y2-Y1)/2
      BY=(Y2+Y1)/2
      ETA1=(Y2-Y1)/(2*SQRT(AX**2+AY**2))
      ETA2=(X1-X2)/(2*SQRT(AX**2+AY**2))
C
C  COMPUTE THE DISTANCE FROM THE POINT TO THE LINE OF THE ELEMENT
C
      IF(AX)10,20,10
   10 TA=AY/AX
      DIST=ABS((TA*XP-YP+Y1-TA*X1)/SQRT(TA**2+1)) 
      GO TO 30
   20 DIST=ABS(XP-X1)
C
C  DETERMINE THE DIRECTION OF THE OUTWARD NORMAL
C 
   30 SIG=(X1-XP)*(Y2-YP)-(X2-XP)*(Y1-YP) 
      IF(SIG)31,32,32 
   31 DIST=-DIST
   32 D111=0. 
      D211=0. 
      D112=0. 
      D212=0. 
      D122=0. 
      D222=0. 
      S111=0. 
      S211=0. 
      S112=0. 
      S212=0. 
      S122=0. 
      S222=0. 
C
C  COMPUTE D AND S COEFFICIENTS
C
      FA=1-4*XNU
      AL=1-2*XNU
      DE=4*3.141592*(1-XNU) 
      DO 40 I=1,4 
      XCO(I)=AX*GI(I)+BX
      YCO(I)=AY*GI(I)+BY
      RA=SQRT((XP-XCO(I))**2+(YP-YCO(I))**2)
      RD1=(XCO(I)-XP)/RA
      RD2=(YCO(I)-YP)/RA
      D111=D111+(AL*RD1+2*RD1**3)*OME(I)*SQRT(AX**2+AY**2)/(DE*RA)
      D211=D211+(2*RD1**2*RD2-AL*RD2)*OME(I)*SQRT(AX**2+AY**2)/(DE*RA)
      D112=D112+(AL*RD2+2*RD1**2*RD2)/(DE*RA)*OME(I)*SQRT(AX**2+AY**2)
      D212=D212+(AL*RD1+2*RD1*RD2**2)/(DE*RA)*OME(I)*SQRT(AX**2+AY**2)
      D122=D122+(2*RD1*RD2**2-AL*RD1)/(DE*RA)*OME(I)*SQRT(AX**2+AY**2)
      D222=D222+(AL*RD2+2*RD2**3)/(DE*RA)*OME(I)*SQRT(AX**2+AY**2)
      S111=S111+(2*DIST/RA*(AL*RD1+XNU*2*RD1-4*RD1**3)+4*XNU*ETA1*RD1**2
     1+AL*(2*ETA1*RD1**2+2*ETA1)-FA*ETA1)*2*GE/(DE*RA**2)*OME(I)*SQRT(AX
     2**2+AY**2)
      S211=S211+(2*DIST/RA*(AL*RD2-4*RD1**2*RD2)+4*XNU*ETA1*RD1*RD2+AL*2
     1*ETA2*RD1**2-FA*ETA2)*2*GE/(DE*RA**2)*OME(I)*SQRT(AX**2+AY**2)
      S112=S112+(2*DIST/RA*(XNU*RD2-4*RD1**2*RD2)+2*XNU*(ETA1*RD2*RD1+ET
     1A2*RD1**2)+AL*(2*ETA1*RD1*RD2+ETA2))*2*GE/(DE*RA**2)*OME(I)*SQRT(A
     2X**2+AY**2) 
      S212=S212+(2*DIST/RA*(XNU*RD1-4*RD1*RD2**2)+2*XNU*(ETA1*RD2**2+ETA
     12*RD1*RD2)+AL*(2*ETA2*RD1*RD2+ETA1))*2*GE/(DE*RA**2)*OME(I)*SQRT(A
     2X**2+AY**2) 
      S122=S122+(2*DIST/RA*(AL*RD1-4*RD1*RD2**2)+4*XNU*ETA2*RD1*RD2+AL*2
     1*ETA1*RD2**2-FA*ETA1)*2*GE/(DE*RA**2)*OME(I)*SQRT(AX**2+AY**2)
   40 S222=S222+(2*DIST/RA*(AL*RD2+2*XNU*RD2-4*RD2**3)+4*XNU*ETA2*RD2**2
     1+AL*(2*ETA2*RD2**2+2*ETA2)-FA*ETA2)*2*GE/(DE*RA**2)*OME(I)*SQRT(AX
     2**2+AY**2)
      RETURN
      END 
C-----------------------------------------------------------------------
      SUBROUTINE OUTPTEC(XM,YM,FI,DFI,CX,CY,SSOL,DSOL)
C
C  PROGRAM 35 
C
C  THIS SUBROUTINE PRINTS THE VALUES OF THE DISPLACEMENTS
C  AND TRACTIONS AT BOUNDARY NODES. IT ALSO PRINTS THE VALUES
C  OF DISPLACEMENTS AND STRESSES AT INTERNAL POINTS
C
      DIMENSION XM(50),YM(50),FI(100),DFI(100)
      DIMENSION CX(20),CY(20),SSOL(60),DSOL(40) 
      COMMON N,L,NC(5),M,GE,XNU,INP,IPR 
C
      WRITE(IPR,100)
  100 FORMAT(' ',79('*')//1X,'RESULTS'//2X,'BOUNDARY NODES'//6X
     1,'X',12X,'Y',9X,'DISPL. X',5X,'DISPL. Y',4X,
     2'TRACTION X',3X,'TRACTION Y'/) 
      DO 10 I=1,N 
   10 WRITE(IPR,200) XM(I),YM(I),FI(2*I-1),FI(2*I),DFI(2*I-1),DFI(2*I)
  200 FORMAT(6(1X,E12.5)) 
C
      IF(L.EQ.0.) GO TO 30
      WRITE(IPR,300)
  300 FORMAT(//2X,'INTERNAL POINTS DISPLACEMENTS'//8X,'X',15X,'Y',10X,  
     1'DISPLACEMENT X',5X,'DISPLACEMENT Y')
      DO 20 K=1,L 
   20 WRITE(IPR,400)CX(K),CY(K),DSOL(2*K-1),DSOL(2*K)
      WRITE(IPR,350)
  350 FORMAT(//2X,'INTERNAL POINTS STRESSES'//8X,'X',15X,'Y',12X,
     1'SIGMA X',10X,'TAU XY',9X,'SIGMA Y')
      DO 25 K=1,L
   25 WRITE(IPR,450) CX(K),CY(K),SSOL(3*K-2),SSOL(3*K-1),SSOL(3*K)  
  400 FORMAT(2(2X,E14.7),2(5X,E14.7)) 
  450 FORMAT(5(2X,E14.7))
   30 WRITE(IPR,500)
  500 FORMAT(' ',79('*'))
      RETURN
      END 
C-----------------------------------------------------------------------      

